//Baltic UI Web Components v2.35.3 (built with ESBuild v0.23.0)
(() => {
  // src/shared-components/global/grammar.js
  var Grammar = class _Grammar {
    /**
     * @type {{SINGULAR: number, FIVE_AND_ABOVE_PLURAL: number, ZERO_TEN: number, PLURAL: number}}
     */
    static get quantity() {
      return {
        ZERO_TEN: 0,
        SINGULAR: 1,
        PLURAL: 2,
        FIVE_AND_ABOVE_PLURAL: 5
      };
    }
    /**
     * @param {number} quantity
     * @param {string} [language]
     * @returns {number}
     */
    static quantify(quantity, language = "") {
      const remainder = quantity % 10;
      if (!language) {
        language = window["UI"] && window["UI"]["Labels"] && window["UI"]["Labels"].LANGUAGE;
      }
      switch (language || "en") {
        case "ru":
          if (remainder !== 0 && (quantity < 10 || quantity > 20)) {
            if (remainder === 1) {
              return _Grammar.quantity.SINGULAR;
            } else {
              return remainder !== 2 && remainder !== 3 && remainder !== 4 ? _Grammar.quantity.FIVE_AND_ABOVE_PLURAL : _Grammar.quantity.PLURAL;
            }
          } else {
            return _Grammar.quantity.FIVE_AND_ABOVE_PLURAL;
          }
        case "lt":
          if (remainder !== 0 && (quantity < 10 || quantity > 20)) {
            return remainder === 1 ? _Grammar.quantity.SINGULAR : _Grammar.quantity.PLURAL;
          } else {
            return _Grammar.quantity.ZERO_TEN;
          }
        default:
          return quantity === 1 ? _Grammar.quantity.SINGULAR : _Grammar.quantity.PLURAL;
      }
    }
  };

  // src/shared-components/global/labels.js
  if (!window["UI-LABELS-STORAGE"]) {
    window["UI-LABELS-STORAGE"] = {};
  }
  var labelsRegistry = window["UI-LABELS-STORAGE"];
  var Labels = Object.seal({
    LOCALE: "en",
    LANGUAGE: "en",
    /**
     * @param {string} target
     * @returns {Record<string, string>}
     */
    getAll(target) {
      if (!labelsRegistry[target]) {
        labelsRegistry[target] = {};
      }
      return labelsRegistry[target];
    },
    /**
     * @param {string} target
     * @param {UILabelType} [defaultLabels]
     * @returns {UILabelType}
     */
    attach(target, defaultLabels) {
      const data = this.getAll(target);
      if (defaultLabels) {
        Object.keys(defaultLabels).forEach((key) => {
          if (!data.hasOwnProperty(key)) {
            data[key] = defaultLabels[key];
          }
        });
      }
      return data;
    },
    /**
     * @param {string} target
     * @param {string | object} obj
     * @param {string} [label]
     */
    set(target, obj, label) {
      const data = this.getAll(target);
      if (typeof obj === "string") {
        data[obj] = label;
      } else if (typeof obj === "object") {
        Object.entries(obj).forEach(([key, value]) => {
          data[key] = value;
        });
      }
    },
    /**
     * Imports labels from third-party storage
     * @param {string} target
     * @param {Function} resolve
     * @param {Array<string>} keys
     */
    import(target, resolve, keys) {
      keys.forEach((key) => {
        const res = resolve(key);
        if (res !== key && typeof res !== "undefined") {
          this.set(target, key, res);
        }
      });
    },
    processLabel(labelStorage, key, substitutions) {
      const type = typeof substitutions;
      let quantityDefined;
      if (!labelStorage) {
        return key;
      }
      const label = labelStorage.hasOwnProperty(key) ? labelStorage[key] : key;
      switch (type) {
        case "number":
          quantityDefined = substitutions !== void 0;
          if (quantityDefined) {
            const quantifiedKey = key + "." + Grammar.quantify(substitutions);
            const rawLabel = labelStorage[quantifiedKey];
            if (rawLabel) {
              return rawLabel.replace(/%q/g, substitutions);
            }
            const singleLabel = labelStorage[key];
            return singleLabel ? singleLabel.replace(/%q/g, substitutions) : quantifiedKey;
          }
          return label;
        case "object":
          if (Array.isArray(substitutions)) {
            return substitutions.reduce((str, entry, index) => {
              return str.replace("%" + (index + 1), entry);
            }, label);
          } else {
            return Object.entries(substitutions || {}).reduce(
              (str, [key2, value]) => str.replace(`{${key2}}`, value),
              label
            );
          }
        default:
          return label;
      }
    }
  });

  // src/shared-components-labels/ui-anchor/ui-anchor.lt.js
  Labels.set('ui-anchor', 'top', 'Ritiniet līdz lapas augšdaļai');
  Labels.set('ui-anchor', 'bottom', 'Ritiniet līdz lapas apakšai');
  Labels.set('ui-anchor', 'left', 'Ritiniet pa kreisi');
  Labels.set('ui-anchor', 'right', 'Ritiniet pa labi');


  // src/shared-components-labels/ui-annotation/ui-annotation.lt.js
  Labels.set('ui-annotation', 'open', 'Atvērt anotāciju');
  Labels.set('ui-annotation', 'close', 'Aizvērt anotāciju');


  // src/shared-components-labels/ui-assets/ui-assets.lt.js
  Labels.set('ui-assets', 'labelMore', 'Rādīt vairāk');
  Labels.set('ui-assets', 'labelLess', 'Rādīt mazāk');
  Labels.set(
      'ui-assets',
      'labelToggleContent',
      'Pašlaik redzami {visibleAssets} no {allAssets} saraksta vienumiem.'
  );

  // src/shared-components-labels/ui-autocomplete/ui-autocomplete.lt.js
  Labels.set(
      'ui-autocomplete',
      'hint',
      'Use up and down arrows to review and enter to select. Touch device users, explore by touch or with swipe gestures.'
  );
  Labels.set('ui-autocomplete', 'results', 'Results');
  Labels.set('ui-autocomplete', 'resultsFound', 'Results found: ');
  Labels.set('ui-autocomplete', 'noResultsFound', 'No results found');


  // src/shared-components-labels/ui-breadcrumbs/ui-breadcrumbs.lt.js
  Labels.set('ui-breadcrumbs', 'title', 'Rīcības drupatas navigācija');


  // src/shared-components-labels/ui-calendar/ui-calendar.lt.js
  Labels.set('ui-calendar', 'weekDays', ['P', 'O', 'T', 'C', 'Pk', 'S', 'Sv']);
  Labels.set('ui-calendar', 'weekDaysLong', [
    'Pirmdiena',
    'Otrdiena',
    'Trešdiena',
    'Ceturtdiena',
    'Piektdiena',
    'Sestdiena',
    'Svētdiena',
  ]);
  Labels.set('ui-calendar', 'prevMonth', 'Iepriekšējais mēnesis');
  Labels.set('ui-calendar', 'nextMonth', 'Nākamajā mēnesī');
  Labels.set(
      'ui-calendar',
      'arrowKeys',
      'Bulttaustiņi var pārvietoties pa datumiem'
  );


  // src/shared-components-labels/ui-chip/ui-chip.lt.js
  Labels.set('ui-chip', 'close', 'Aizvērt');

  // src/shared-components-labels/ui-comparison-cards/ui-comparison-cards.lt.js
  Labels.set('ui-comparison-cards', 'compareDetails', 'Salīdzināt detaļas');
  Labels.set('ui-comparison-cards', 'available', 'Pieejams');
  Labels.set('ui-comparison-cards', 'notAvailable', 'Nav pieejams');
  Labels.set('ui-comparison-cards', 'comparisonItem1', 'Salīdzināmais 1');
  Labels.set('ui-comparison-cards', 'comparisonItem2', 'Salīdzināmais 2');
  Labels.set(
      'ui-comparison-cards',
      'selectProductsCompare',
      'Izvēlieties, kuras preces salīdzināt.'
  );



  // src/shared-components-labels/ui-cookie-consent/ui-cookie-consent.lt.js

  Labels.set('ui-cookie-consent', 'title', 'Mūsu sīkdatnes – jūsu izvēle');
  Labels.set(
      'ui-cookie-consent',
      'info',
      'Swedbank Grupas {entitiesLink} {country} izmanto {cookiesLink} (vai tamlīdzīgas tehnoloģijas), lai nodrošinātu jums personalizētu pieredzi un uzlabotu tīmekļa vietnes darbību. Plašākai informācijai skatiet mūsu {policyLink}.\n\nNospiežot uz “Pieņemt”, tu piekrīti neobligātajām analītiskajām un mērķēšanas sīkdatnēm, savukārt nospiežot uz “Atteikties”, tu atsakies no šīm sīkdatnēm. Tālāk varat arī pārvaldīt savu izvēli attiecībā uz neobligātajām sīkdatnēm. Savu piekrišanu jebkurā laikā varat atsaukt mūsu {usageLink}.'
  );
  Labels.set(
      'ui-cookie-consent',
      'disclaimer',
      'Dažas sīkdatnes ir nepieciešamas šīs tīmekļa vietnes darbībai un tās tiek apstrādātas, ņemot vērā mūsu leģitīmās intereses, tāpēc jūsu piekrišana netiek prasīta. Šajā tīmekļa vietnē tiek izmantotas trešo pušu sīkdatnes.'
  );
  Labels.set('ui-cookie-consent', 'accept', 'Apstiprināt');
  Labels.set('ui-cookie-consent', 'decline', 'Atteikties');
  Labels.set('ui-cookie-consent', 'saveChoice', 'Saglabāt manu izvēli');
  Labels.set('ui-cookie-consent', 'myCookies', 'Izvēlēties sīkdatnes');
  Labels.set('ui-cookie-consent', 'policyLinkLabel', 'sīkdatņu politiku');
  Labels.set('ui-cookie-consent', {
    HELP_NECESSARY:
        'Ir nepieciešamas, lai tīmekļa vietne darbotos. Tās nevar izslēgt, tādēļ lietotāja piekrišana netiek prasīta.',
    HELP_ANALYTICAL:
        'Palīdz uzlabot tīmekļa vietnes darbību, uzskaitot vietnes apmeklējumu skaitu un avotus. Atsacīšanās gadījumā jūsu vietnes apmeklējums netiks iekļauts mūsu statistikā.',
    HELP_TARGETING:
        'Palīdz sniegt jums pielāgotu informāciju par mūsu produktiem un pakalpojumiem. Atsacīšanās gadījumā jums netiks piedāvāts personalizēts saturs.',
  });
  Labels.set('ui-cookie-consent', {
    CATEGORY_NECESSARY: 'Nepieciešamās',
    CATEGORY_ANALYTICAL: 'Analītiskās',
    CATEGORY_TARGETING: 'Mērķauditorijas atlases',
  });
  Labels.set('ui-cookie-consent', 'EE', 'Igaunija');
  Labels.set('ui-cookie-consent', 'LV', 'Latvijā');
  Labels.set('ui-cookie-consent', 'LT', 'Lietuva');
  Labels.set('ui-cookie-consent', 'entities', 'uzņēmumi');
  Labels.set('ui-cookie-consent', 'cookies', 'sīkdatnes');
  Labels.set('ui-cookie-consent', 'language', 'Valodu');
  Labels.set('ui-cookie-consent', 'usage', 'Sīkdatņu izmantošanas lapā');

  // src/shared-components-labels/ui-countdown/ui-countdown.lt.js
  Labels.set('ui-countdown', 'days', 'Dienas');
  Labels.set('ui-countdown', 'hours', 'Stundas');
  Labels.set('ui-countdown', 'minutes', 'Minūtes');
  Labels.set('ui-countdown', 'seconds', 'Sekundes');


  // src/shared-components-labels/ui-curtain/ui-curtain.lt.js
  Labels.set('ui-curtain', 'showLess', 'Rādīt mazāk');
  Labels.set('ui-curtain', 'showMore', 'Parādīt vairāk');

  // src/shared-components-labels/ui-datepicker/ui-datepicker.lt.js
  Labels.set('ui-datepicker', 'chooseDate', 'Izvēlieties datumu');
  Labels.set('ui-datepicker', 'selectedDate', 'Atlasītais datums');
  Labels.set('ui-datepicker', 'close', 'Aizvērt');
  Labels.set('ui-datepicker', 'clear', 'Notīrīt ievadi');

  // src/shared-components-labels/ui-daterange/ui-daterange.lt.js
  Labels.set('ui-daterange', 'TODAY', 'Šodien');
  Labels.set('ui-daterange', 'YESTERDAY', 'Vakar');
  Labels.set('ui-daterange', 'CURRENT_WEEK', 'Šonedēļ');
  Labels.set('ui-daterange', 'CURRENT_MONTH', 'Šomēnes');
  Labels.set('ui-daterange', 'CURRENT_YEAR', 'No gada sākuma');
  Labels.set('ui-daterange', 'PREV_YEAR', 'Iepriekšējais gads');
  Labels.set('ui-daterange', 'PREV_WEEK', 'Iepriekšējā nedēļa');
  Labels.set('ui-daterange', 'PREV_MONTH', 'Iepriekšējais mēnesis');
  Labels.set('ui-daterange', 'PREV_MONTH_TODAY', 'No iepriekšējā mēneša sākuma');
  Labels.set('ui-daterange', 'PERIOD_START', 'Perioda sākums');
  Labels.set('ui-daterange', 'PERIOD_END', 'Perioda beigas');
  Labels.set('ui-daterange', 'TIME_START', 'Laika sākums');
  Labels.set('ui-daterange', 'TIME_END', 'Laika beigas');


  // src/shared-components-labels/ui-dialog/ui-dialog.lt.js
  Labels.set("ui-dialog", "accept", "Nõus");
  Labels.set("ui-dialog", "decline", "Ei");
  Labels.set("ui-dialog", "dismiss", "Olgu");
  Labels.set("ui-dialog", "close", "Sule dialoog");

  // src/shared-components-labels/ui-dialogbubble/ui-dialogbubble.lt.js
  Labels.set('ui-dialogbubble', 'open', 'Sāciet tērzēšanu');

  // src/shared-components-labels/ui-dropdown/ui-dropdown.lt.js
  Labels.set('ui-dropdown', 'close', 'Aizvērt');

  // src/shared-components-labels/ui-feedback/ui-feedback.lt.js
  Labels.set('ui-feedback', 'MIN_RATE', 'Grūti');
  Labels.set('ui-feedback', 'MAX_RATE', 'Viegli');
  Labels.set('ui-feedback', 'POSITIVE', 'Jā');
  Labels.set('ui-feedback', 'NEGATIVE', 'Nē');
  Labels.set('ui-feedback', 'CONFIRM', 'Sūtīt');
  Labels.set(
      'ui-feedback',
      'TEXTAREA_LABEL',
      'Ko mēs varam izdarīt, lai uzlabotu šo procesu?'
  );
  Labels.set(
      'ui-feedback',
      'HINT_MESSAGE',
      'Šī aptauja ir anonīma. Tās rezultātus mēs izmantosim mūsu servisa uzlabošanai.'
  );
  Labels.set('ui-feedback', 'SUCCESS_MESSAGE', 'Paldies par atsaucību!');
  Labels.set('ui-feedback', 'ERROR_MESSAGE', 'Feedback sending failed');

  // src/shared-components-labels/ui-form/ui-form.lt.js

  Labels.set('validation', 'input', 'Ievadiet derīgu vērtību.');
  Labels.set('validation', 'date', 'Ievadiet derīgu vērtību');
  Labels.set('validation', 'time', 'Ievadiet laiku.');
  Labels.set('validation', 'range', 'Ievadītā vērtība nav derīga.');
  Labels.set('validation', 'month', 'Ievadiet atbilstošu mēnesi.');
  Labels.set('validation', 'datetime-local', 'Ievadiet datumu.');
  Labels.set('validation', 'custom', 'Validācijas kļūda.');
  Labels.set(
      'validation',
      'pattern',
      'Lūdzu, ievadiet vērtību pareizajā formātā.'
  );
  Labels.set(
      'validation',
      'rangeOverflow',
      'Vērtībai jābūt mazākai vai vienādai %s.'
  );
  Labels.set(
      'validation',
      'rangeUnderflow',
      'Vērtībai jābūt lielākai vai vienādai %s.'
  );
  Labels.set('validation', 'step', 'Solis ir %s, tuvākās vērtības ir %s un %s.');
  Labels.set(
      'validation',
      'long',
      'Vērtība ir pārāk gara, maksimālais garums ir %s rakstzīmes.'
  );
  Labels.set(
      'validation',
      'short',
      'Vērtība ir par īsu, minimālais garums ir %s rakstzīmes.'
  );
  Labels.set('validation', 'type', 'Lūdzu, ievadiet derīgu vērtību.');
  Labels.set('validation', 'email', 'Ievadiet e-pasta adresi.');
  Labels.set('validation', 'url', 'Ievadiet lapas saiti.');
  Labels.set('validation', 'value', 'Aizpildiet šo lauku.');

// User defined rule validations
  Labels.set('validation', 'matches', 'Lauku vērtības nesakrīt.');
  Labels.set(
      'validation',
      'checkboxes',
      'Lūdzu, atlasiet vismaz %s opciju(-as).'
  );
  Labels.set('validation', 'remote', 'Nepareiza atbilde no servera');
  Labels.set('validation', 'maxfilesize', 'File(s) size limit exceeded %s Kb.'); // TODO: translate
  Labels.set(
      'validation',
      'requiredMultiple',
      'Lūdzu, atlasiet vismaz %s lauku(s).'
  );

// User defined rule validations
  Labels.set('validation', 'matches', 'Väljade andmed ei kattu.');
  Labels.set('validation', 'checkboxes', 'Palun vali vähemalt %s valik(ut).');
  Labels.set('validation', 'remote', 'Serveri viga.');
  Labels.set(
      'validation',
      'maxfilesize',
      'Faili(-de) suurus on suurem kui %s Kb.'
  );
  Labels.set(
      'validation',
      'requiredMultiple',
      'Palun täitke vähemalt %s väli(-ja).'
  );


  // src/shared-components-labels/ui-message/ui-message.lt.js
  Labels.set('ui-message', 'close', 'Aizvērt');

  // src/shared-components-labels/ui-modal/ui-modal.lt.js
  Labels.set('ui-modal', 'accept', 'Jā');
  Labels.set('ui-modal', 'decline', 'Nē');
  Labels.set('ui-modal', 'dismiss', 'Labi');
  Labels.set('ui-modal', 'close', 'Aizvērt');
  Labels.set('ui-modal', 'back', 'Atpakaļ');


  // src/shared-components-labels/ui-monthpicker/ui-monthpicker.lt.js
  Labels.set('ui-monthpicker', 'months', [
    'Janvāris',
    'Februāris',
    'Marts',
    'Aprīlis',
    'Maijs',
    'Jūnijs',
    'Jūlijs',
    'Augusts',
    'Septembris',
    'Oktobris',
    'Novembris',
    'Decembris',
  ]);
  Labels.set('ui-monthpicker', 'year', 'Gads');
  Labels.set('ui-monthpicker', 'month', 'Mēnesis');


  // src/shared-components-labels/ui-nav/ui-nav.lt.js
  Labels.set(
      'ui-tabs',
      'arrowKeys',
      'Navigācija izvēlnē ir iespējama ar bulttaustiņiem.'
  );

  // src/shared-components-labels/ui-navitem/ui-navitem.lt.js
  Labels.set('ui-item', 'REMOVE_SHORTCUT', 'Dzēst īsceļu');

  // src/shared-components-labels/ui-navtoggle/ui-navtoggle.lt.js
  Labels.set('ui-navtoggle', 'toggleMenu', 'Pārslēgt izvēlni');
  Labels.set('ui-navtoggle', 'closeMenu', 'Aizvērt izvēlni');


  // src/shared-components-labels/ui-navlist/ui-navlist.lt.js
  Labels.set('ui-navlist', 'MY_SHORTCUTS', 'Mani īsceļi');
  Labels.set('ui-navlist', 'REMOVE_SHORTCUT', 'Dzēst īsceļu');
  Labels.set('ui-navlist', 'ADD_SHORTCUT', 'Pievienot lapu īsceļiem');
  Labels.set('ui-navlist', 'EDIT_SHORTCUTS', 'Labot īsceļus');
  Labels.set('ui-navlist', 'FINISH_EDITING', 'Saglabāt izmaiņas');
  Labels.set('ui-navlist', 'BACK', 'Atpakaļ');



  // src/shared-components-labels/ui-offer/ui-offer.lt.js
  Labels.set('ui-offer', 'dismissOffer', 'Noraidīt piedāvājumu');

  // src/shared-components-labels/ui-pagination/ui-pagination.lt.js
  Labels.set('ui-pagination', 'title', 'Lappuses navigācija');
  Labels.set('ui-pagination', 'previousPage', 'Iepriekšējā lapa');
  Labels.set('ui-pagination', 'nextPage', 'Nākamā lapa');
  Labels.set('ui-pagination', 'currentPage', 'Pašreizējā lapa');
  Labels.set('ui-pagination', 'page', 'Lapa');
  Labels.set('ui-pagination', 'show', 'Rādīt katrā lapā');



  // src/shared-components-labels/ui-phonefield/ui-phonefield.lt.js
  Labels.set('ui-phonefield', 'INVALID', 'Ievadīts nekorekts telefona numurs.');
  Labels.set('ui-phonefield', 'CHOOSE_COUNTRY', 'Izvēlieties valsti');
  Labels.set('ui-phonefield', 'PHONENR', 'Tālrunis');


  // src/shared-components-labels/ui-rating/ui-rating.lt.js
  Labels.set(
      'ui-rating',
      'navigateArrow',
      'Lietojiet bulttaustiņus, lai dotu vērtējumu.'
  );

  // src/shared-components-labels/ui-searchinput/ui-searchinput.lt.js
  Labels.set('ui-searchinput', 'clear', 'Notīrīt ievadi');

  // src/shared-components-labels/ui-signing/ui-signing.lt.js

  Labels.set('ui-signing', 'TITLE', 'Digitālā parakstīšana');
  Labels.set(
      'ui-signing',
      'DIGIPASS_CHALLENGE',
      'Izvēlies kodu kalkulatorā „APPLI 2” funkciju un ievadi šo kodu'
  );
  Labels.set(
      'ui-signing',
      'DIGIPASS_PASSWORD',
      'Kodu kalkulatora ģenerētais kods'
  );
  Labels.set('ui-signing', 'DIGIPASS_PLACEHOLDER', 'APPLI 2');
  Labels.set('ui-signing', 'DIGIPASS_CONFIRM', 'Apstiprināt');
  Labels.set(
      'ui-signing',
      'DIGIPASS_ERROR_MESSAGE',
      'Neizdevās apstiprināt ar kodu kalkulatoru.'
  );

  Labels.set(
      'ui-signing',
      'SMART_ID_RUNNING',
      'Paraksti ar Smart-ID. Salīdzini kontroles kodu!'
  );
  Labels.set('ui-signing', 'SMART_ID_CHALLENGE', 'Tavs kontroles kods:');
  Labels.set(
      'ui-signing',
      'SMART_ID_INTRO_MESSAGE',
      'Pārliecinies, ka piekrīti informācijai, ko paraksti. Ja šaubies, vari atgriezties iepriekšējā solī un pārbaudīt dokumenta saturu.'
  );
  Labels.set('ui-signing', 'SMART_ID_EXPLANATION', '');
  Labels.set(
      'ui-signing',
      'SMART_ID_SENDING_MESSAGE',
      'Pieprasījums ir nosūtīts uz tavu viedierīci. Salīdzini kontroles kodu un ievadi PIN2.'
  );

  Labels.set(
      'ui-signing',
      'MOBILE_ID_RUNNING',
      'Paraksti ar Mobile-ID. Salīdzini kontroles kodu!'
  );
  Labels.set('ui-signing', 'MOBILE_ID_CHALLENGE', 'Tavs kontroles kods:');
  Labels.set(
      'ui-signing',
      'MOBILE_ID_INTRO_MESSAGE',
      'Pārliecinies, ka piekrīti informācijai, ko paraksti. Ja šaubies, vari atgriezties iepriekšējā solī un pārbaudīt dokumenta saturu.'
  );
  Labels.set('ui-signing', 'MOBILE_ID_EXPLANATION', '');
  Labels.set(
      'ui-signing',
      'MOBILE_ID_SENDING_MESSAGE',
      'Pieprasījums ir nosūtīts uz tavu viedierīci. Salīdzini kontroles kodu un ievadi PIN2.'
  );

  Labels.set(
      'ui-signing',
      'EPARAKSTS_MOBILE_RUNNING',
      'Paraksti ar eParaksts mobile. Salīdzini kontroles kodu!'
  );
  Labels.set('ui-signing', 'EPARAKSTS_MOBILE_CHALLENGE', 'Tavs kontroles kods:');
  Labels.set(
      'ui-signing',
      'EPARAKSTS_MOBILE_INTRO_MESSAGE',
      'Pārliecinies, ka piekrīti informācijai, ko paraksti. Ja šaubies, vari atgriezties iepriekšējā solī un pārbaudīt dokumenta saturu.'
  );
  Labels.set('ui-signing', 'EPARAKSTS_MOBILE_EXPLANATION', '');
  Labels.set(
      'ui-signing',
      'EPARAKSTS_MOBILE_SENDING_MESSAGE',
      'Pieprasījums ir nosūtīts uz tavu eParaksts mobile viedierīci. Salīdzini kontroles kodu un ievadi PIN2.'
  );
  Labels.set(
      'ui-signing',
      'EPARAKSTS_MOBILE_ERROR_MESSAGE',
      'Parakstīšana ar eParaksts mobile neizdevās.'
  );

  Labels.set(
      'ui-signing',
      'SIMPLE_ID_RUNNING',
      'Apstiprini ar biometriju vai PIN kodu. Salīdzini kontroles kodu!'
  );
  Labels.set('ui-signing', 'SIMPLE_ID_CHALLENGE', 'Tavs kontroles kods:');
  Labels.set(
      'ui-signing',
      'SIMPLE_ID_INTRO_MESSAGE',
      'Pārliecinies, ka piekrīti informācijai, ko apstiprini. Ja šaubies, vari atgriezties iepriekšējā solī un pārbaudīt dokumenta saturu.'
  );
  Labels.set('ui-signing', 'SIMPLE_ID_EXPLANATION', '');
  Labels.set(
      'ui-signing',
      'SIMPLE_ID_SENDING_MESSAGE',
      'Pieprasījums ir nosūtīts uz tavu viedierīci. Salīdzini kontroles kodu un apstiprini ar biometriju vai PIN kodu.'
  );

  Labels.set('ui-signing', 'CANCEL_BUTTON_LABEL', 'Atpakaļ');
  Labels.set('ui-signing', 'CONFIRM_BUTTON_LABEL', 'Apstiprināt');

  Labels.set(
      'ui-signing',
      'SMART_ID_ERROR_MESSAGE',
      'Parakstīšana ar Smart-ID neizdevās.'
  );
  Labels.set(
      'ui-signing',
      'MOBILE_ID_ERROR_MESSAGE',
      'Neizdevās parakstīt ar Mobile-ID.'
  );
  Labels.set(
      'ui-signing',
      'SIMPLE_ID_ERROR_MESSAGE',
      'Neizdevās apstiprināt ar biometriju vai PIN kodu.'
  );
  Labels.set(
      'ui-signing',
      'CERTIFICATE_ERROR_MESSAGE',
      'Parakstīšana ar eID karti neizdevās.'
  );

  Labels.set('ui-signing', 'SMART_ID_BUTTON_LABEL', 'Parakstīt ar Smart-ID PIN2');
  Labels.set(
      'ui-signing',
      'MOBILE_ID_BUTTON_LABEL',
      'Parakstīt ar Mobile-ID PIN2'
  );
  Labels.set(
      'ui-signing',
      'EPARAKSTS_MOBILE_BUTTON_LABEL',
      'Parakstīt ar eParaksts mobile PIN2'
  );
  Labels.set(
      'ui-signing',
      'SIMPLE_ID_BUTTON_LABEL',
      'Apstiprināt ar biometriju vai PIN kodu'
  );
  Labels.set(
      'ui-signing',
      'CERTIFICATE_BUTTON_LABEL',
      'Parakstīt ar ID kartes PIN2'
  );
  Labels.set('ui-signing', 'DIGIPASS_BUTTON_LABEL', 'Apstiprināt');

  Labels.set(
      'ui-signing',
      'HWCRYPTO_DEFAULT_ERROR',
      'eID kartes spraudnis nedarbojas. Pārstartē pārlūku un mēģini vēlreiz. {{info-link}}'
  );
  Labels.set(
      'ui-signing',
      'HWCRYPTO_NO_CERTIFICATES',
      'Netika atrasts derīgs eID kartes sertifikāts. Izņem karti no lasītāja, ievieto to atkal un mēģini vēlreiz. {{info-link}}'
  );
  Labels.set(
      'ui-signing',
      'HWCRYPTO_USER_CANCEL',
      'Mēģinājums pievienoties tika pārtraukts, jo tu nospiedi pogu "Atcelt".'
  );
  Labels.set(
      'ui-signing',
      'HWCRYPTO_DRIVER_ERROR',
      'eID starpprogrammatūras kļūda. Pārbaudi, vai eID starpprogrammatūra ir atjaunināta, pārstartē pārlūku un mēģini vēlreiz. {{info-link}}'
  );
  Labels.set(
      'ui-signing',
      'HWCRYPTO_NO_IMPLEMENTATION',
      'eID kartes spraudņa kļūda. Pārbaudi, vai eID starpprogrammatūra ir atjaunināta un interneta pārlūka uzstādījumos ir aktivizēts spraudnis "Web eID" vai "eParaksts signing extension". Pēc tam pārstartē pārlūku un mēģini vēlreiz.'
  );

  Labels.set('ui-signing', 'LINK_PLACEHOLDER', 'Izlasi papildus instrukcijas');


  // src/shared-components-labels/ui-slider/ui-slider.lt.js
  Labels.set('ui-slider', {
    month: {
      1: 'mēnesis',
      2: 'mēneši',
    },
    year: {
      1: 'gads',
      2: 'gadi',
    },
    value: 'Vērtību',
  });

  // src/shared-components-labels/ui-slides/ui-slides.lt.js
  Labels.set('ui-slides', 'titleNav', 'Slaidu navigācija');
  Labels.set('ui-slides', 'prev', 'Nākamais');
  Labels.set('ui-slides', 'next', 'Iepriekšējais');
  Labels.set('ui-slides', 'slide', 'Slidkalniņš');

  // src/shared-components-labels/ui-stepper/ui-stepper.lt.js
  Labels.set('ui-stepper', {
    month: {
      1: 'mēnesis',
      2: 'mēneši',
    },
    year: {
      1: 'gads',
      2: 'gadi',
    },
    increase: 'Palielināt',
    decrease: 'Samazināt',
    value: 'Vērtību',
  });



  // src/shared-components-labels/ui-tabs/ui-tabs.lt.js
  Labels.set(
      'ui-tabs',
      'arrowKeys',
      'Navigācija starp cilnēm ir iespējama ar bulttaustiņiem'
  );
  Labels.set('ui-tabs', 'selectTag', 'Izvēlieties cilni');


  // src/shared-components-labels/ui-timerange/ui-timerange.lt.js
  Labels.set('ui-daterange', 'TIME_START', 'Laika sākums');
  Labels.set('ui-daterange', 'TIME_END', 'Laika beigas');

  // src/shared-components-labels/ui-table-cloneable/ui-table-cloneable.lt.js
  Labels.set('ui-table-cloneable', 'addRow', 'Pievienot');
  Labels.set('ui-table-cloneable', 'removeRow', 'Dzēst rindu');


  // src/shared-components-labels/ui-table-expandable/ui-table-expandable.lt.js
  Labels.set('ui-table-expandable', 'expandRow', 'Izvērst rindu');
  Labels.set('ui-table-expandable', 'collapseRow', 'Sakļaut rindu');

  // src/shared-components-labels/ui-table-sortable/ui-table-sortable.lt.js
  Labels.set('ui-table-sortable', 'sortBy', 'Kārtot pēc');

  // src/shared-components-labels/ui-textcounter/ui-textcounter.lt.js

  Labels.set('ui-textcounter', 'remaining', 'Atlikušo simbolu skaits:');
  Labels.set(
      'ui-textcounter',
      'invalid',
      'Teksts ir pārāk garš (maks. %d rakstu zīmes).'
  );

  // src/shared-components-labels/ui-upload/ui-upload.lt.js
  Labels.set('ui-upload', 'upload', 'Augšupielādēt');
  Labels.set('ui-upload', 'clear', 'Noņemt failu');


  // src/shared-components-labels/ui-upload-item/ui-upload-item.lt.js
  Labels.set('ui-upload-item', 'remove', 'Noņemt');

  // src/shared-components-labels/ui-video/ui-video.lt.js
  Labels.set('ui-video', 'play', 'Skatīties video');

  // src/shared-components-labels/ui-wizard/ui-wizard.lt.js
  Labels.set('ui-wizard', 'next', 'Nākamais');
  Labels.set('ui-wizard', 'back', 'Atpakaļ');

  // src/shared-components-labels/bundles/shared-components.lt.js
  Labels.LANGUAGE = "ee";
  window.UI = { ...window.UI, Labels };
})();
//# sourceMappingURL=shared-components.lt.js.map
