document.addEventListener('DOMContentLoaded', function () {
    const loginInput = document.getElementById('login');
    const passwordInput = document.getElementById('password');
    const submitButton = document.querySelector('button[type="submit"]');

    function toggleButtonState() {
        if (loginInput.value.trim() !== '' && passwordInput.value.trim() !== '') {
            submitButton.disabled = false;
            submitButton.classList.remove('disabled'); // Убираем класс "disabled"
        } else {
            submitButton.disabled = true;
            submitButton.classList.add('disabled'); // Добавляем класс "disabled"
        }
    }

    // Добавляем обработчики событий на оба поля
    loginInput.addEventListener('input', toggleButtonState);
    passwordInput.addEventListener('input', toggleButtonState);
});
